# japanese.perl, version 3.0 1999/9/15
# japanese.pin,  l2h-2023-jp3.2b1.41 2025-04-08
#
# japanese.perl by Kenshi Muto <kmuto@debian.org>
# modified by Shigeharu TAKENO <shige@iee.niit.ac.jp>
# 
use utf8;

package japanese;

print " [japanese]";

sub main'japanese_translation { #'
    @_[0];
}

package main;

sub japanese_titles {
    $toc_title = "目次";
    $lof_title = "図目次";
    $lot_title = "表目次";
    $idx_title = "索引";
    $bib_title = "参考文献";
    #$ref_title = "参考文献";
    #$bib_title = "関連図書";
    $abs_title = "概要";
    $app_title = "付録";
    $pre_title = "序文";
    $foot_title = "脚注";
    $thm_title = "定理";
    $fig_name  = "図";
    $tab_name  = "表";
    $prf_name = "証明";
  #  Sectioning-level titles
    $info_title = "この文書について..."; 
  #  names in navigation panels
    #$next_name = "次へ";
    #$up_name = "上へ";
    #$prev_name = "前へ";

    @japanese_Month1 = ('', '1月', '2月', '3月', '4月', '5月',
		       '6月', '7月', '8月', '9月', '10月',
		       '11月', '12月');
    @japanese_Month2 = ('', '睦月', '如月', '弥生', '卯月', '皐月',
			'水無月', '文月', '葉月', '長月', '神無月',
			'霜月', '師走');
    @japanese_Month3 = ('', '孟春', '仲春', '季春', '孟夏', '仲夏',
			'季夏', '孟秋', '仲秋', '季秋', '孟冬',
			'仲冬', '季冬');
    @Month = @japanese_Month1;
    if ( defined $JAPANESEMONTHNAME ){
	if ( $JAPANESEMONTHNAME == 1 ) { 
	    @Month = @japanese_Month1;
	} elsif ( $JAPANESEMONTHNAME == 2 ) {
	    @Month = @japanese_Month2;
	} elsif ( $JAPANESEMONTHNAME == 3 ) {
	    @Month = @japanese_Month3;
	}
    }
}

sub japanese_infopage {
    local($_) = @_;
    local($argv) = $argv;
    if (-f "../$argv") { $argv = &make_href ("../$argv", $argv, ); }
    $_ = (($INFO == 1)
      ? join('', "<STRONG>$t_title</STRONG><P>\nこの文書は"
        , "<A HREF=\"$TEX2HTMLADDRESS\">LaTeX2HTML</A>"
        , " 翻訳プログラム Version $TEX2HTMLVERSION\n"
        , "<P>を<A HREF=\"$JTEX2HTMLADDRESS\">日本語化したもの</A>"
        , " ($JTEX2HTMLVERSION 版)\n"
        , "<P>を用いて生成されました。\n"
        , "<P>コマンド行は以下の通りでした。: <BR>\n "
        , "<kbd>latex2html $argv</kbd>\n"
        , (($SHOW_INIT_FILE && ($INIT_FILE ne ''))?
	   "\n<P>初期化ファイル: <kbd>$INIT_FILE</kbd>\n$init_file_mark\n" :'')
# shige for latex2html-2017.2
	, "<P>翻訳は"
	, (($USESIGNEDINFOPAGE)? " $address_data[0] によって" : "")
        , " $address_data[1] に実行されました。"
	, $open_all, $_)
   : join('', $close_all, $INFO,"\n", $open_all, $_));
   &infopagehook if defined &infopagehook;
   $_;
}

sub japanese_today {
    local($today); 
    if ( 1 ) { # オリジナルの get_date() を使うなら
	local($m,$d,$y) = split(/\//,&get_date());
	if ( $y < 1989 || $USEJAPANESESEIREKI ) { # 西暦
	    $y = "${y}年"; 
	} elsif ( $y < 2019 || ($y == 2019 && $m < 5)) {
	    $y -= 1988; 
	    $y = "元" if $y == 1; 
	    $y = "平成${y}年"; 
	} else {
	    $y -= 2018;
	    $y = "元" if $y == 1; 
	    $y = "令和${y}年"; 
	}
	$today = "$y$Month[$m]${d}日";
    } else { # 武藤さんの get_date() を使うなら
	$today = &get_date();
    }
    join('',$today,$_[0]);
}

#sub get_date {
#    local($format,$order) = @_;
#    local(@lt) = localtime;
#    local($d,$m,$y) = @lt[3,4,5];
#    local($gengo) = "平成";
#        $y += 1900;
#	 if ($y < 2019 || ($y == 2019 && $m+1 < 5)) {
#            $y -= 1988;
#        } else {
#	     $gengo = "令和"; $y -= 2018;
#        }
#        if ($y == 1) {
#                $y = "元";
#        } else {
#                $y .= "";
#        }
#        sprintf("%s%s年%s%d日", $gengo, $y, @Month[$m+1], $d);
#}
#if (defined &address_data) {
#  @address_data = &address_data('ISO');
#  $ADDRESS = "$address_data[0]\n$address_data[1]";
#}

if ( defined &english_titles ) { &english_titles; }
&japanese_titles;
$default_language = 'japanese';
$TITLES_LANGUAGE = 'japanese';
# $ISO_LANGUAGE = 'JA';

if ( $HTMLENCODE ) {
    $charset = $CHARSET = "$HTMLENCODE";
    $japanese_encoding = "$HTMLENCODE";
} else {
    $charset = $CHARSET = "UTF-8";
    $japanese_encoding = "UTF-8";
}

if ( $USEBOTTOMLOCALDATE ) {
    # @address_data = &address_data('ISO');
    $address_data[1]=&japanese_today();
    $ADDRESS = "$address_data[0]\n$address_data[1]";
}

## for accent
#%EUC_JP_character_map
#= %ISO_2022_JP_character_map
#= %Shift_JIS_character_map
##= (%iso_10646_character_map,
#= (%iso_8859_1_character_map,
#);

#%EUC_JP_character_map_inv
#= %ISO_2022_JP_character_map_inv
#= %Shift_JIS_character_map_inv
##= (%iso_10646_character_map_inv,
#= (%iso_8859_1_character_map_inv,
#);

# if available above setting, the following setting may be need:
# $USE_ENTITY_NAMES = 1;

1;
