#! /usr/local/bin/perl
# $Id: j2utf8.pl,v 1.1 2019-08-26 16:10:21+09 shige Exp $
# j2utf8.pl
# Kanji translator from {EUC-JP/SJIS/JIS} to UTF-8 for init file
# 
use Encode;

if ( $#ARGV >= 0 && $ARGV[0] =~ /^euc/i ) {
    binmode STDIN, ":encoding(euc-jp)";
} elsif ( $#ARGV >= 0 && $ARGV[0] =~ /sjis/i ) {
    binmode STDIN, ":encoding(shiftjis)";
} elsif ( $#ARGV >= 0 && $ARGV[0] =~ /^jis/i ) {
    binmode STDIN, ":encoding(iso-2022-jp)";
} else {
    die "Not supported option is specified.";
}
binmode STDOUT, ":utf8";

while ( <STDIN> ) {
    print;
} 
